% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_weightedpct.R
\name{table_weightedpct}
\alias{table_weightedpct}
\title{Calculate table of percentages or N of response distribution for survey items, survey weighted, disaggregated}
\usage{
table_weightedpct(
  df,
  vars_ids,
  vars_strata,
  vars_weights,
  formula_vars,
  ...,
  formula_vars_levels = 0:1,
  by_vars = NULL,
  pct = TRUE,
  willfilter = NULL,
  add_totals = FALSE,
  spread_key = NULL,
  spread_value = "prop",
  arrange_vars = NULL,
  include_SE = FALSE
)
}
\arguments{
\item{df}{a data frame of individual survey data, where each row is an individual}

\item{vars_ids}{a character vector of cluster ids, passed to \code{srvyr::as_survey_design()}}

\item{vars_strata}{a character vector of strata ids, passed to \code{srvyr::as_survey_design()}}

\item{vars_weights}{a character vector of survey weight ids, passed to \code{srvyr::as_survey_design()}}

\item{formula_vars}{a character vector of variables to calculate the percentages of each level for}

\item{...}{captures expressions to pass to \code{dplyr::filter()} or \code{dplyr::transmute()}, depending on the value of argument \code{willfilter}. See Details.}

\item{formula_vars_levels}{a vector of the levels of the the \code{formula_vars}}

\item{by_vars}{a character vector of variables to disaggregate results by. Default is \code{NULL} for no disaggregation. The columns listed must not include NAs.}

\item{pct}{a logical variable indicating whether or not to calculate weighted percentages. Default is \code{TRUE} for weighted percentages. Set to \code{FALSE} for weighted N.}

\item{willfilter}{a logical variable that tells the function whether or not to filter or transmute the data. Leave as default \code{NULL} to not filter or transmute. Set as \code{TRUE} to filter and \code{FALSE} to transmute. See Details.}

\item{add_totals}{logical determining whether to create total rows or columns (as appropriate) that demonstrate the margin that sums to 100. Default is FALSE.}

\item{spread_key}{a string with variable name to pass to \code{names_from} argument of \code{tidyr::pivot_wider()}. Default is \code{NULL}.}

\item{spread_value}{a string with variable name to pass to \code{values_from} argument of \code{tidyr::pivot_wider()}. Default is "prop" (the column of percentages created within the function)}

\item{arrange_vars}{a character vector with variables to pass to \code{dplyr::arrange()}. Default is NULL.}

\item{include_SE}{a logical variable indicating whether to include the standard errors in the table. Default is FALSE. Currently does not work when adding totals, spreading or transmuting.}
}
\value{
a tibble of weighted response percentages or N's
}
\description{
Calculate table of percentages or N of response distribution for survey items, survey weighted, disaggregated
}
\details{
If \code{willfilter} is NULL, the table is not filtered or transmuted. If \code{willfilter} is TRUE, the table is filtered before it is spread or arranged. If \code{willfilter} is FALSE, the table is transmuted after the spread and/or arrange. "..." captures the non-standard evaluation expressions (NSE) to pass to \code{dplyr::filter} or \code{dplyr::transmute()}.

The function performs the following actions with the table after results are calculated in the following order (if applicable): filter, add totals, spread, arrange, transmute
}
\examples{
table_weightedpct(df_adults, 
    vars_ids = c("HHID", "PSU"),
    vars_strata = "strata",
    vars_weights = "weight",
    formula_vars = paste0("EF",1:10),
    formula_vars_levels = 1:5,
    by_vars = "sex")
}
\seealso{
See \code{vignette("programming", package = "dplyr")} for more about non-standard evaluation (NSE)

Other table functions: 
\code{\link{table_basicstats}()},
\code{\link{table_unweightedpctn}()}
}
\concept{table functions}
