% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_data.R
\name{retrieve_data}
\alias{retrieve_data}
\title{Retrieves Data from GENESIS Databases}
\usage{
retrieve_data(tablename, startyear = "", endyear = "",
  regionalschluessel = "", genesis = NULL, ...)
}
\arguments{
\item{tablename}{name of the table to retrieve.}

\item{startyear}{only retrieve values for years equal or larger to \code{startyear}. Default: "".}

\item{endyear}{only retrieve values for years smaller or equal to \code{endyear}. Default: "".}

\item{regionalschluessel}{only retrieve values for a particular regional unit. Default: "".}

\item{genesis}{to authenticate a user and set the database (see below).}

\item{...}{other arguments send to the httr::GET request.}
}
\value{
a \code{data.frame}. Value variables (_val) come with three additional variables (_qual, _lock, _err). The exact nature 
of these variables is unknown, but _qual appears to indicate if _val is a valid value. If _qual=="e" the value in _val is 
valid while if _qual!="e" (then _qual = ("-","/", ".", "x", ... ) ) it is typically zero should/might be set to NA.
}
\description{
\code{retrieve_data} retrieves a single data table.
}
\details{
Use \code{\link{retrieve_datalist}} to find the \code{tablename} based on the table series you are interested in. See the 
package description (\code{\link{wiesbaden}}) for details about setting the login and database.
}
\examples{

 \dontrun{
 # Retrieve values for the table 14111KJ002 which contains the 
 # federal election results on the county level. 
 # Assumes that user/password are stored in ~/.genesis.json

 data <- retrieve_data(tablename="14111KJ002", genesis=c(db="regio") )
 }




}
\seealso{
\code{\link{retrieve_datalist}} \code{\link{wiesbaden}}
}
