% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve_data.R
\name{retrieve_data}
\alias{retrieve_data}
\title{Retrieves Data from GENESIS Databases}
\usage{
retrieve_data(
  tablename,
  startyear = "",
  endyear = "",
  regionalmerkmal = "",
  regionalschluessel = "",
  sachmerkmal = "",
  sachschluessel = "",
  sachmerkmal2 = "",
  sachschluessel2 = "",
  sachmerkmal3 = "",
  sachschluessel3 = "",
  genesis = NULL,
  language = "de",
  ...
)
}
\arguments{
\item{tablename}{name of the table to retrieve.}

\item{startyear}{only retrieve values for years equal or larger to \code{startyear}. Default: "".}

\item{endyear}{only retrieve values for years smaller or equal to \code{endyear}. Default: "".}

\item{regionalmerkmal}{key for Regionalklassifikation. See details for more information. Default: "".}

\item{regionalschluessel}{only retrieve values for a particular regional unit. See details for more information. Default: "".}

\item{sachmerkmal, sachmerkmal2, sachmerkmal3}{key for Sachklassifikation. Default: "".}

\item{sachschluessel, sachschluessel2, sachschluessel3}{value for Sachklassifikation. Default: "".}

\item{genesis}{to authenticate a user and set the database (see below).}

\item{language}{retrieve information in German "de" (default) or in English "en" if available.}

\item{...}{other arguments send to the httr::GET request.}
}
\value{
a \code{data.frame}. Value variables (_val) come with three additional variables (_qual, _lock, _err). The exact nature 
of these variables is unknown, but _qual appears to indicate if _val is a valid value. If _qual=="e" the value in _val is 
valid while if _qual!="e" (then _qual = ("-","/", ".", "x", ... ) ) it is typically zero should/might be set to NA.
}
\description{
\code{retrieve_data} retrieves a single data table.
}
\details{
Use \code{\link{retrieve_datalist}} to find the \code{tablename} based on the table series you are interested in. See the 
package description (\code{\link{wiesbaden}}) for details about setting the login and database. 

The parameter \code{regionalschluessel} can either be a single value (a single Amtlicher Gemeindeschlüssel) or a comma-separated list of values supplied as string. Wildcard character "*" is allowed. If \code{regionalschluessel} is set, the parameter \code{regionalmerkmal} must also be set to GEMEIN, KREISE, REGBEZ, or DLAND.
}
\examples{

 \dontrun{
 # Retrieve values for the table 14111KJ002 which contains the 
 # federal election results on the county level. 
 # Assumes that user/password are stored via save_credentials()

 data <- retrieve_data(tablename="14111KJ002", genesis=c(db="regio") )

 # ... only the values for the AfD. 

 data <- retrieve_data(tablename="14111KJ002", sachmerkmal="PART04", 
   sachschluessel="AFD", genesis=c(db="regio") )

# ... or only values from Saxony

 data <- retrieve_data(tablename="14111KJ002", regionalmerkmal="KREISE", 
   regionalschluessel="14*", genesis=c(db="regio") )

} 

}
\seealso{
\code{\link{retrieve_datalist}} \code{\link{wiesbaden}}
}
