% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_randomfact.R
\name{wiki_randomfact}
\alias{wiki_randomfact}
\title{Generate random facts from historic Wikipedia main pages}
\usage{
wiki_randomfact(
  n_facts = 1L,
  fact = c("any", "didyouknow", "onthisday", "inthenews"),
  bare_fact = FALSE,
  repeats = TRUE
)
}
\arguments{
\item{n_facts}{An integer determining the number of facts that will be generated.}

\item{fact}{String to determine the type of fact to be randomly generated - "any" will generate a random selection.}

\item{bare_fact}{Logical.  Determining whether the fact should be quoted as is or surrounded by a preamble and courtesy statement.}

\item{repeats}{Logical.  Determining if repeat facts should be permitted.  If FALSE the number of facts may be less than requested.}
}
\value{
A vector of strings with random items from Wikipedia's main page - otherwise "I got nothin'"
}
\description{
`wiki_randomfact()` generates random facts from Wikipedia main pages after 1 January 2015.
}
\examples{
wiki_randomfact()
}
