% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{climate}
\alias{climate}
\title{Daily weather summaries for California from 2011 through 2015}
\format{A dataframe with 105850 rows and 7 variables:
\describe{
  \item{fips}{Five-digit code combining the state and county codes from the FIPS publication 6-4 for counties}
  \item{date}{Date on which the climate measures were recorded}
  \item{prcp}{precipitation, in mm}
  \item{snow}{snowfall, in mm}
  \item{snwd}{snow depth, in	mm}
  \item{tmax}{maximum temperature, in degrees Celsius}
  \item{tmin}{minumum temperature, in degrees Celsius}
}}
\source{
\url{https://www1.ncdc.noaa.gov/pub/data/cdo/documentation/GHCND_documentation.pdf}
}
\usage{
climate
}
\description{
A dataframe containing daily weather summaries for California at the county level.
It is created from summarizing the measurements from GHCND stations to the daily level
and by filtering on the date (2011 - 2015), state (CA), and key cols.
}
\details{
Data from the Daily Global Historical Climatology Network (GHCN-Daily) through NOAA’s FTP server.
The data is archived at the National Centers for Environmental Information (NCEI)
(formerly the National Climatic Data Center (NCDC)), and spans from the 1800s to the current year.
}
\keyword{datasets}
