% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{wildfires}
\alias{wildfires}
\title{Geo-referenced California wildfire records from 2011 through 2015}
\format{A dataframe with 31579 rows and 11 variables:
\describe{
  \item{FIRE_NAME}{Name of the incident, from the fire report (primary) or ICS-209 report (secondary)}
  \item{DISCOVER_DATE}{Date on which the fire was discovered or confirmed to exist}
  \item{CONT_DATE}{Date on which the fire was declared contained or otherwise controlled}
  \item{STAT_CAUSE_DESCR}{Description of the (statistical) cause of the fire}
  \item{FIRE_SIZE}{Estimate of acres within the final perimeter of the fire}
  \item{FIRE_SIZE_CLASS}{Code for fire size based on the number of acres within the final fire
                         perimeter expenditures (A=greater than 0 but less than or equal to 0.25 acres,
                         B=0.26-9.9 acres, C=10.0-99.9 acres, D=100-299 acres, E=300 to 999 acres,
                         F=1000 to 4999 acres, and G=5000+ acres)}
  \item{LATITUDE}{Latitude (NAD83) for point location of the fire (decimal degrees)}
  \item{LONGITUDE}{Longitude (NAD83) for point location of the fire (decimal degrees)}
  \item{STATE}{Two-letter alphabetic code for the state in which the fire burned}
  \item{FIPS_CODE}{Three-digit code from the FIPS publication 6-4 for counties}
  \item{FIPS_NAME}{County name from the FIPS publication 6-4 for counties}
}}
\source{
\url{https://www.kaggle.com/rtatman/188-million-us-wildfires}
}
\usage{
wildfires
}
\description{
A dataframe containing Calfornia wildfire records at the county level.
It is created from the Kaggle US wildfire records data by filtering on
the date (2011- 2015), state (CA), and key cols and cleaning up the
missing counties and reformatting the dates.
}
\details{
This data publication contains a spatial database of wildfires that
occurred in the United States from 1992 to 2015.
}
\keyword{datasets}
