% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProportionAreaSearched.R
\name{getProportionAreaSearched}
\alias{getProportionAreaSearched}
\title{Create proportion of area searched table from spatial data}
\usage{
getProportionAreaSearched(turbinePoints, turbineName, turbinePlots,
  turbineMastRadius, maxDistance)
}
\arguments{
\item{turbinePoints}{spatial points object with with data frame indicating turbine names}

\item{turbineName}{string, indicating the variable name for the turbine names in \code{turbinePoints} and plot names in \code{turbinePlots}}

\item{turbinePlots}{spatial polygon objects indicating the search area around the turbine points}

\item{turbineMastRadius}{integer, radius of the turbine mast}

\item{maxDistance}{integer, indicating how far from the turbine that searches occured}
}
\value{
Data frame of proportion of area searched for each annulus. \code{distanceFromTurbine} column represents outer radius of annuli.
}
\description{
Calculate proportion of area searched around wind turbine based on turbine location data and polygons of search area.
}
\details{
The \code{\link[sf]{sf}} package is used to calculate overlapping areas between the searched area \code{turbinePlots} and one unit annulus around the \code{turbinePoints}. The annuli increase out to a distance of \code{maxDistance}.
}
\examples{


data(turbineSpatial)

propSearch <- getProportionAreaSearched(turbinePoints=turbineSpatial$turbinePoints,
turbineName='turbName',turbinePlots=turbineSpatial$turbinePlots,
 turbineMastRadius=2,maxDistance=10)


}
