% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometricRectanglePropSearchTable.R
\name{geometricRectanglePropSearchTable}
\alias{geometricRectanglePropSearchTable}
\title{Create proportion of area searched table for a rectangular full plot}
\usage{
geometricRectanglePropSearchTable(
  side1,
  side2 = side1,
  mastRadius,
  annulusWidth = 1,
  ...
)
}
\arguments{
\item{side1}{Numeric, length of the side of the rectangle.}

\item{side2}{Numeric, length of the second side of the rectangle, default is
\code{side1} which produces a square.}

\item{mastRadius}{Integer, radius of the turbine mast.}

\item{annulusWidth}{Integer, width of annulus, default is 1.}

\item{...}{Currently ignored.}
}
\value{
Data frame of proportion of area searched for each annulus. \code{distanceFromTurbine} column represents the outer radius of each annulus.
}
\description{
Calculate the areas of intersection of a series of nested annuli with a rectangle.
}
\details{
Searches are conducted around a turbine within a rectangle for bird
  and bat carcasses. This function creates a data frame of proportion of area
  searched within each annulus ring. The turbine is assumed to be centered
  within the rectangle.
}
\examples{

## square 50 x 50
propSearch <- geometricRectanglePropSearchTable(side1 = 50,
                                                mastRadius = 2)


## square 50 x 70
propSearch <- geometricRectanglePropSearchTable(side1 = 50,
                                                side2 = 70,
                                                mastRadius = 2)



}
\seealso{
geometricRoadPadPropSearchTable circleBoxInt
}
