% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutation.R
\name{mutation}
\alias{mutation}
\title{Mutation Method}
\usage{
mutation(a, p)
}
\arguments{
\item{a}{The binary matrix of all individuals. (matrix)}

\item{p}{The mutation rate. (numeric)}
}
\value{
Returns a binary matrix with mutated genes. (matrix)
}
\description{
Mutate the genes of every chromosome or individual with
low probability.
}
\examples{
## Create 4 random individuals with binary values
a <- cbind(bin=sample(c(0,1),20,replace=TRUE,prob = c(70,30)),
        bin.1=sample(c(0,1),20,replace=TRUE,prob = c(30,70)),
        bin.2=sample(c(0,1),20,replace=TRUE,prob = c(30,70)),
        bin.3=sample(c(0,1),20,replace=TRUE,prob = c(30,70)))
a

## Mutate the individuals with a low percentage
aMut <- mutation(a,0.1)
## Check which values are not like the originals
a==aMut

## Mutate the individuals with a high percentage
aMut <- mutation(a,0.4)
## Check which values are not like the originals
a==aMut

}
\author{
Sebastian Gatscha
}
