% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InfluPoints.R
\name{InfluPoints}
\alias{InfluPoints}
\title{Find potentially influencing turbines}
\usage{
InfluPoints(t, wnkl, dist, polYgon, dirct, plotAngles = FALSE)
}
\arguments{
\item{t}{A data.frame of the current individual with X and Y
coordinates}

\item{wnkl}{A numeric value indicating the angle, at which no wake
influences are considered. Default is 20 degrees.}

\item{dist}{A numeric value indicating the distance, after which
the wake effects are considered to be eliminated.
Default is 100km.}

\item{polYgon}{A shapefile representing the considered area}

\item{dirct}{A numeric value indicating the current wind direction}

\item{plotAngles}{A logical variable, which is used to plot the
distances and angles. Default is FALSE.}
}
\value{
Returns a list of all individuals of the current generation
which could potentially influence other turbines. List includes the
relevant coordinates, the distances and angles in between and assigns
the Point ID.
}
\description{
Find all turbines that could potentially influence
another turbine and save them to a list.
}
\examples{
library(sp)
library(raster)
## Exemplary input Polygon with 2km x 2km:
polYgon <- Polygon(rbind(c(0, 0), c(0, 2000),
c(2000, 2000), c(2000, 0)))
polYgon <- Polygons(list(polYgon), 1)
polYgon <- SpatialPolygons(list(polYgon))
Projection <- "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000
+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
proj4string(polYgon) <- CRS(Projection)
plot(polYgon, axes = TRUE)

t <- as.matrix(cbind(x = runif(10, 0, extent(polYgon)[2]),
     y = runif(10, 0, extent(polYgon)[4])))
wnkl <- 20
dist <- 100000
dirct <- 0

resInfluPoi <- InfluPoints(t, wnkl, dist, polYgon, dirct, plotAngles = TRUE)
str(resInfluPoi)

}
\author{
Sebastian Gatscha
}
