% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visibility.R
\name{plot_farm_3d}
\alias{plot_farm_3d}
\title{plot_farm_3d}
\usage{
plot_farm_3d(DEM, turbines, zscale_sphere = 200, zscale_3d = 200,
  texture = "imhof1", z = 1, sunangle = 315, ...)
}
\arguments{
\item{DEM}{The ISO3 code of the country}

\item{turbines}{boolean, indicating if polygon should be cropped.
Default is TRUE}

\item{zscale_sphere}{zscale for rayshader::sphere_shade. Default is 200.}

\item{zscale_3d}{zscale for rayshader::plot_3d Default is 200.}

\item{texture}{texture for rayshader::sphere_shade.}

\item{z}{zoom value. Default is 1}

\item{sunangle}{Default '315' (NW). The direction of the main 
highlight color.}

\item{...}{Arguments passed on to rayshader::plot_3d}
}
\description{
Plot a wind farm with rayshader in 3D. (Still experimental)
}
\examples{
\dontrun{
library(sp)
Polygon1 <- Polygon(rbind(c(4488182, 2663172), c(4488182, 2669343),
                          c(4499991, 2669343), c(4499991, 2663172)))
Polygon1 <- Polygons(list(Polygon1), 1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000
+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
proj4string(Polygon1) <- CRS(Projection)
DEM_meter <- getDEM(Polygon1)

turbloc = spsample(DEM_meter[[2]], 10, type = "random");

plot_farm_3d(DEM_meter[[1]], turbloc, texture="imhof4")
}
}
\author{
Sebastian Gatscha
}
