% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selection.R
\name{selection}
\alias{selection}
\title{Selection Method}
\usage{
selection(fit, Grid, teil, elitism, nelit, selstate, verbose)
}
\arguments{
\item{fit}{A list of all fitness-evaluated individuals}

\item{Grid}{Is the indexed grid output from \code{\link{grid_area}}}

\item{teil}{A numeric value that determines the selection percentage}

\item{elitism}{Boolean value which indicates whether elitism should be
included or not.}

\item{nelit}{If \code{elitism} is TRUE, then this input variable determines
the amount of individuals in the elite group.}

\item{selstate}{Determines which selection method is used, "FIX" selects a
constant percentage and "VAR" selects a variable percentage, depending on
the development of the fitness values.}

\item{verbose}{If TRUE, will print out further information.}
}
\value{
Returns list with 2 elements. Element 1 is the binary encoded matrix
  which shows all selected individuals. Element 2 represent the mean fitness
  values of each parental team.
}
\description{
Select a certain amount of individuals and recombine them to
  parental teams. Add the mean fitness value of both parents to the parental
  team. Depending on the selected \code{selstate}, the algorithm will either
  take always 50 percent or a variable percentage of the current population.
  The variable percentage depends on the evolution of the populations fitness
  values.
}
\examples{
\dontrun{
## Create a random rectangular shapefile
library(sp)
Polygon1 <- Polygon(rbind(c(0, 0), c(0, 2000), c(2000, 2000), c(2000, 0)))
Polygon1 <- Polygons(list(Polygon1),1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+init=epsg:3035"
proj4string(Polygon1) <- CRS(Projection)

## Calculate a Grid and an indexed data.frame with coordinates and grid cell Ids.
Grid1 <- grid_area(shape = Polygon1,resol = 200,prop = 1);
Grid <- Grid1[[1]]
AmountGrids <- nrow(Grid)

startsel <- init_population(Grid,10,20);
wind <- as.data.frame(cbind(ws=12,wd=0))
wind <- list(wind, probab = 100)
fit <- fitness(selection = startsel, referenceHeight = 100, RotorHeight=100,
               SurfaceRoughness=0.3,Polygon = Polygon1, resol1 = 200,
               rot = 20, dirspeed = wind, 
               srtm_crop = "", topograp = FALSE, cclRaster = "")
allparks <- do.call("rbind",fit);

## SELECTION
## print the amount of Individuals selected. Check if the amount 
## of Turbines is as requested.
selec6best <- selection(fit, Grid, 2, TRUE, 6, "VAR")
selec6best <- selection(fit, Grid, 2, TRUE, 6, "FIX")
selec6best <- selection(fit, Grid, 4, FALSE, 6, "FIX")
}
}
\seealso{
Other Genetic Algorithm Functions: 
\code{\link{crossover}()},
\code{\link{fitness}()},
\code{\link{genetic_algorithm}()},
\code{\link{init_population}()},
\code{\link{mutation}()},
\code{\link{trimton}()},
\code{\link{windfarmGA}()}
}
\concept{Genetic Algorithm Functions}
