% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossover.R
\name{permutations}
\alias{permutations}
\title{Enumerate the Combinations or Permutations of the Elements of a
Vector}
\usage{
permutations(n, r, v = 1:n)
}
\arguments{
\item{n}{Size of the source vector}

\item{r}{Size of the target vectors}

\item{v}{Source vector. Defaults to 1:n}
}
\value{
Returns a matrix where each row contains a vector of length r.
}
\description{
permutations enumerates the possible permutations. The
function is forked and minified from gtools::permutations
}
\references{
Venables, Bill. "Programmers Note", R-News, Vol 1/1, Jan. 2001.
\url{https://cran.r-project.org/doc/Rnews/}
}
\seealso{
Other Helper Functions: 
\code{\link{dup_coords}()},
\code{\link{getDEM}()},
\code{\link{getISO3}()},
\code{\link{get_grids}()},
\code{\link{grid_area}()},
\code{\link{hexa_area}()},
\code{\link{isSpatial}()},
\code{\link{readintegerSel}()},
\code{\link{readinteger}()},
\code{\link{splitAt}()},
\code{\link{windata_format}()}
}
\author{
Original versions by Bill Venables 
\email{Bill.Venables@cmis.csiro.au.} Extended to handle repeats.allowed
by Gregory R. Warnes \email{greg@warnes.net.}
}
\concept{Helper Functions}
