% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid_area.R
\name{grid_area}
\alias{grid_area}
\title{Make a grid from a Simple Feature Polygon}
\usage{
grid_area(shape, size = 500, prop = 1, plotGrid = FALSE)
}
\arguments{
\item{shape}{Simple Feature Polygon of the considered area}

\item{size}{The cellsize of the grid in meters. Default is 500}

\item{prop}{A factor used for grid calculation. It determines the minimum
percentage that a grid cell must cover the area. Default is 1}

\item{plotGrid}{Logical value indicating whether the results should be
plotted. Default is \code{FALSE}}
}
\value{
Returns a list with 2 elements. List element 1 will have the grid
cell IDS, and the X and Y coordinates of the centers of each grid cell.
List element 2 is the grid as Simple Feature Polygons, which is used for
plotting purposes.
}
\description{
Create a grid from a given polygon with a certain resolution
and proportionality. The grid cell centroids represent possible
wind turbine locations.
}
\note{
The grid of the genetic algorithm will have a resolution of \code{Rotor
  * fcrR}. See the arguments of \code{\link{genetic_algorithm}}
}
\examples{
\donttest{
## Exemplary input Polygon with 2km x 2km:
library(sf)
Polygon1 <- sf::st_as_sf(sf::st_sfc(
  sf::st_polygon(list(cbind(
    c(0, 0, 2000, 2000, 0),
    c(0, 2000, 2000, 0, 0)
  ))),
  crs = 3035
))

## Create a Grid
grid_area(Polygon1, 200, 1, TRUE)
grid_area(Polygon1, 400, 1, TRUE)

## Examplary irregular input Polygon
Polygon1 <- sf::st_as_sf(sf::st_sfc(
  sf::st_polygon(list(cbind(
    c(0, 0, 2000, 3000, 0),
    c(20, 200, 2000, 0, 20)
  ))),
  crs = 3035
))

## Create a Grid
grid_area(Polygon1, 200, 1, TRUE)
grid_area(Polygon1, 200, 0.1, TRUE)
grid_area(Polygon1, 400, 1, TRUE)
grid_area(Polygon1, 400, 0.1, TRUE)
}
}
\seealso{
Other Helper Functions: 
\code{\link{get_grids}()},
\code{\link{hexa_area}()},
\code{\link{isSpatial}()},
\code{\link{permutations}()},
\code{\link{readinteger}()},
\code{\link{readintegerSel}()},
\code{\link{splitAt}()},
\code{\link{windata_format}()}
}
\concept{Helper Functions}
