% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_winfapapi.R
\name{get_pot}
\alias{get_pot}
\title{A function to obtain Peaks-Over-Threshold (POT) data using the NRFA API}
\usage{
get_pot(station, getAmax = FALSE)
}
\arguments{
\item{station}{the NRFA station number for which peaks over threshold information should be obtained. It can also be a vector of station numbers}

\item{getAmax}{logical. If \code{TRUE} information on the annual maxima values will be retrieved and attached to the \code{WaterYearInfo} table}
}
\value{
Like \code{\link{read_pot}} a list of three objects \code{tablePOT}, \code{WaterYearInfo} and \code{dateRange}.

\code{tablePOT} contains a table with all the peaks above the threshold present in the record

\code{WaterYearInfo} a table containing the information on the percentage of missing values
in any water year for which some data is available in the POT record. This is useful to assess
whether the lack of exceedances is genuine or the result of missing data and to assess whether the threshold
exceedances present in \code{tablePOT} can be deemed to be representative of the whole year

\code{dateRange} a vector with the first and last date of recording for the POT record as provided in the [POT Details] field.
Note that this period might be different than the period for which annual maxima records are available
}
\description{
The function queries the NRFA API for the .PT file similar to the WINFAP file for a given stations. It then processes the file in a fashion similar to \code{\link{read_pot}}.
}
\examples{
\donttest{
  p40003 <- get_pot(40003) # the Medway at Teston / East Farleigh
  p40003$tablePOT[p40003$tablePOT$WaterYear > 1969 &
        p40003$tablePOT$WaterYear < 1977,]
  ### no events in 1971 nor 1975
  p40003$WaterYearInfo[p40003$WaterYearInfo$WaterYear > 1969 &
        p40003$WaterYearInfo$WaterYear < 1977,]
  # in 1971 all records are valid,
  # in 1975 no exceedances
  # might be due to the fact that almost no valid record are available

  p40003 <- get_pot(40003, getAmax = TRUE)
  p40003$WaterYearInfo[p40003$WaterYearInfo$WaterYear > 1969 &
       p40003$WaterYearInfo$WaterYear < 1977,]
  # the annual maximum in 1971 and 1975 was below the threshold
  # no events exceeded the threshold
}
}
\seealso{
\code{\link{read_pot}}. Information on the peaks over threshold records and river flow gauging in the UK can be found at the National River Flow Archive website \url{https://nrfa.ceh.ac.uk}
}
