% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row_arith.R
\name{row_arith}
\alias{row_arith}
\alias{row_arith.matrix}
\alias{row_arith.data.frame}
\title{Row-wise arithmetic operations}
\usage{
row_arith(.data, ...)

\method{row_arith}{matrix}(
  .data,
  operator = c("+", "-", "*", "/"),
  cumulative = FALSE,
  output_mode,
  output_class,
  ...
)

\method{row_arith}{data.frame}(
  .data,
  operator = c("+", "-", "*", "/"),
  cumulative = FALSE,
  output_mode,
  output_class,
  ...
)
}
\arguments{
\item{.data}{A two-dimensional data structure.}

\item{...}{
  Arguments passed on to \code{\link[=op_ctrl]{op_ctrl}}
  \describe{
    \item{\code{na_action}}{One of ("exclude", "pass"), possibly abbreviated. See \link[stats:na.pass]{stats::na.pass} for
semantics.}
    \item{\code{cols}}{A vector indicating which columns to consider for the operation. If \code{NULL}, all
columns are used. If its length is 0, no columns are considered. Negative numbers, logical
values, character vectors representing column names, and \link[tidyselect:select_helpers]{tidyselect::select_helpers} are
supported.}
    \item{\code{rows}}{Like \code{cols} but for row indices, and without \code{tidyselect} support.}
  }}

\item{operator}{One of ("+", "-", "*", "/").}

\item{cumulative}{Logical. Whether to return the cumulative operation.}

\item{output_mode}{Passed to \code{\link[=op_ctrl]{op_ctrl()}}. If missing, it will be inferred.}

\item{output_class}{Passed to \code{\link[=op_ctrl]{op_ctrl()}}. If missing, it will be inferred.}
}
\description{
Row-wise arithmetic operations
}
\details{
Conceptually, this function takes each row, say \code{x}, and executes \code{Reduce(operator, unlist(x))}.
\code{x} may be a list of values with different non-character types (like a \code{data.frame} row), \code{NA}
values can be excluded, and results can be accumulated.
}
\examples{

mat <- matrix(1L:9L, nrow = 3L, ncol = 3L)

row_arith(mat, "-")
row_arith(mat, "-", cumulative = TRUE)

df <- data.frame(bool = TRUE, int = 1L, double = 1.0, complex = 1+0i)

# all columns promoted to complex
row_arith(df, "*")
row_arith(df, "/", cumulative = TRUE)

# only promotion to integer is needed
row_arith(df, "+", cols = 1:2)

}
