% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dir.R
\name{with_dir}
\alias{with_dir}
\alias{local_dir}
\title{Working directory}
\usage{
with_dir(new, code)

local_dir(new = list(), .local_envir = parent.frame())
}
\arguments{
\item{new}{\verb{[character(1)]}\cr New working directory}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{.local_envir}{\verb{[environment]}\cr The environment to use for scoping.}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
argument.
}
\description{
Temporarily change the current working directory.
}
\examples{
getwd()

with_dir(tempdir(), getwd())
}
\seealso{
\code{\link{withr}} for examples

\code{\link[=setwd]{setwd()}}
}
