% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiehpow.R
\name{shiehpow}
\alias{shiehpow}
\title{Power Calculation Using the Shieh et. al. Approach}
\arguments{
\item{n}{Sample size of first sample (numeric)}

\item{m}{Sample size of second sample (numeric)}

\item{p}{Effect size, P(X<Y) (numeric)}

\item{alpha}{Type I error rate (numeric)}

\item{dist}{The distribution type for the two groups (“exp”, “dexp”, or “norm”) (string)}

\item{sides}{Options are “two.sided” and “one.sided” (string)}
}
\description{
The purpose of \emph{shiehpow} is to perform a power analysis for a one
or two-sided Wilcoxon-Mann-Whitney test using the method developed by Shieh and
colleagues.
}
\note{
When calculating power for dist=”norm”, \emph{shiehpow} uses 100,000 draws from a Z ~ N(0,1)
distribution for the internal calculation of p2 and p3 from Shieh et al. (2006); thus 
\emph{shiehpow} normal distribution power results may vary in the thousandths place from one run 
to the next.
}
\examples{
# We want to calculate the statistical power to compare the distance between mutations on a DNA 
# strand in two groups of people. Each group (X and Y) has 10 individuals. We assume that the 
# distance between mutations in the first group is exponentially distributed with rate 3. We assume 
# that the probability that the distance in the first group is less than the distance in the second 
# group (i.e., P(X<Y)) is 0.8. The desired type I error is 0.05.

shiehpow(n = 10, m = 10, p = 0.80, alpha = 0.05, dist = "exp", sides = "two.sided")

}
\references{
Shieh, G., Jan, S. L., Randles, R. H. (2006). On power and sample size
determinations for the Wilcoxon–Mann–Whitney test. Journal of Nonparametric
Statistics, 18(1), 33-43.

Mollan K.R., Trumble I.M., Reifeis S.A., Ferrer O., Bay C.P., Baldoni P.L.,
Hudgens M.G. Exact Power of the Rank-Sum Test for a Continuous Variable, 
arXiv:1901.04597 [stat.ME], Jan. 2019.
}
