% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-dependencies.R
\name{wood_core_dependencies}
\alias{wood_core_dependencies}
\title{Get dependencies of a core R package}
\usage{
wood_core_dependencies(package)
}
\arguments{
\item{package}{\code{character(1)}\cr
Name of a package to query for.}
}
\value{
A data frame with three columns, all in string format:
\itemize{
\item \code{package} (package name),
\item \code{version} (minimum version requirement or \code{NA} if none),
\item \code{type} (dependency type, e.g. \code{"Imports"}).
}
}
\description{
This function collects the dependencies of the selected core R
package.
}
\examples{
wood_core_dependencies("tcltk")

}
\seealso{
Functions for core R packages:
\code{\link{wood_core_packages}()},
\code{\link{wood_core_version}()}

Functions that query package dependencies:
\code{\link{wood_bioc_dependencies}()},
\code{\link{wood_cran_dependencies}()},
\code{\link{wood_dependencies}()},
\code{\link{wood_github_dependencies}()},
\code{\link{wood_local_dependencies}()},
\code{\link{wood_runiverse_dependencies}()},
\code{\link{wood_url_dependencies}()}
}
\concept{core}
\concept{dependencies}
