#' hprice2
#'
#' Wooldridge Source: D. Harrison and D.L. Rubinfeld (1978), “Hedonic Housing Prices and the Demand for Clean Air,” by Harrison, D. and D.L.Rubinfeld, Journal of Environmental Economics and Management 5, 81-102. Diego Garcia, a former Ph.D. student in economics at MIT, kindly provided these data, which he obtained from the book Regression Diagnostics: Identifying Influential Data and Sources of Collinearity, by D.A. Belsey, E. Kuh, and R. Welsch, 1990. New York: Wiley. Data loads lazily.
#'
#' @section Notes: The census contains rich information on variables such as median housing prices, median income levels, average family size, and so on, for fairly small geographical areas. If such data can be merged with pollution data, one can update the Harrison and Rubinfeld study. Presumably, this has been done in academic journals.
#'
#' Used in Text: pages 108, 132-133, 190-191, 196-197.
#'
#' @docType data
#'
#' @usage data('hprice2')
#'
#' @format A data.frame with 506 observations on 12 variables:
#' \itemize{
#'  \item \strong{price:} median housing price, $
#'  \item \strong{crime:} crimes committed per capita
#'  \item \strong{nox:} nit ox concen; parts per 100m
#'  \item \strong{rooms:} avg number of rooms
#'  \item \strong{dist:} wght dist to 5 employ centers
#'  \item \strong{radial:} access. index to rad. hghwys
#'  \item \strong{proptax:} property tax per $1000
#'  \item \strong{stratio:} average student-teacher ratio
#'  \item \strong{lowstat:} perc of people 'lower status'
#'  \item \strong{lprice:} log(price)
#'  \item \strong{lnox:} log(nox)
#'  \item \strong{lproptax:} log(proptax)
#' }
#' @source \url{https://www.cengage.com/cgi-wadsworth/course_products_wp.pl?fid=M20b&product_isbn_issn=9781111531041}
#' @examples  str(hprice2)
"hprice2"
 
 
