% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aoa.R
\name{fit_aoa}
\alias{fit_aoa}
\title{Fit age of acquisition estimates for Wordbank data}
\usage{
fit_aoa(
  instrument_data,
  measure = "produces",
  method = "glm",
  proportion = 0.5,
  age_min = min(instrument_data$age, na.rm = TRUE),
  age_max = max(instrument_data$age, na.rm = TRUE)
)
}
\arguments{
\item{instrument_data}{A data frame returned by \code{get_instrument_data},
which must have an "age" column and a "num_item_id" column.}

\item{measure}{One of "produces" or "understands" (defaults to "produces").}

\item{method}{A string indicating which smoothing method to use:
\code{empirical} to use empirical proportions,  \code{glm} to fit a
logistic linear model, \code{glmrob} a robust logistic linear model
(defaults to \code{glm}).}

\item{proportion}{A number between 0 and 1 indicating threshold proportion of
children.}

\item{age_min}{The minimum age to allow for an age of acquisition. Defaults
to the minimum age in \code{instrument_data}}

\item{age_max}{The maximum age to allow for an age of acquisition. Defaults
to the maximum age in \code{instrument_data}}
}
\value{
A data frame where every row is an item, the item-level columns from
  the input data are preserved, and the \code{aoa} column contains the age of
  acquisition estimates.
}
\description{
For each item in the input data, estimate its age of acquisition as the
earliest age (in months) at which the proportion of children who
understand/produce the item is greater than some threshold. The proportions
used can be empirical or first smoothed by a model.
}
\examples{
\dontrun{
eng_ws_data <- get_instrument_data(language = "English (American)",
                                   form = "WS",
                                   items = c("item_1", "item_42"),
                                   administrations = TRUE)
eng_ws_aoa <- fit_aoa(eng_ws_data)
}
}
