% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossling.R
\name{get_crossling_data}
\alias{get_crossling_data}
\title{Get item-by-age summary statistics for items across languages}
\usage{
get_crossling_data(uni_lemmas, db_args = NULL)
}
\arguments{
\item{uni_lemmas}{A character vector of uni_lemmas.}

\item{db_args}{List with arguments to connect to wordbank mysql database
(host, dbname, user, and password).}
}
\value{
A dataframe with a row for each combination of language, item, and
  age, and columns for summary statistics for the group: number of children
  (\code{n_children}), means (\code{comprehension}, \code{production}),
  standard deviations (\code{comprehension_sd}, \code{production_sd}); and
  item-level variables (\code{item_id}, \code{definition}, \code{uni_lemma},
  \code{lexical_category}, \code{lexical_class}).
}
\description{
Get item-by-age summary statistics for items across languages
}
\examples{
\donttest{
crossling_data <- get_crossling_data(uni_lemmas = "dog")
}
}
