% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{wb_topic}
\alias{wb_topic}
\title{World Bank topic data}
\source{
\url{https://api.worldbank.org/v2/topics}
}
\usage{
wb_topic(topic = NULL, lang = "en")
}
\arguments{
\item{topic}{(\code{character()}) topic to query. Default \code{NULL}.
If \code{NULL}, all topics are returned.}

\item{lang}{(\code{character(1)}) language to query. Default \code{"en"}.}
}
\value{
A \code{data.frame()} with the available topics. The columns are:
\item{id}{The topic ID.}
\item{value}{The topic value.}
\item{source_note}{The source note.}
}
\description{
List all topics supported by the World Bank API.
}
\examples{
wb_topic()
}
\seealso{
Other indicators data: 
\code{\link{wb_country}()},
\code{\link{wb_income_level}()},
\code{\link{wb_indicator}()},
\code{\link{wb_language}()},
\code{\link{wb_lending_type}()},
\code{\link{wb_region}()},
\code{\link{wb_source}()}
}
\concept{indicators data}
