% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identify_outlier.R
\name{identify_outlier}
\alias{identify_outlier}
\title{Identify metric outliers over a date interval}
\usage{
identify_outlier(data, group_var = "Date", metric = "Collaboration_hours")
}
\arguments{
\item{data}{A Standard Person Query dataset in the form of a data frame.}

\item{group_var}{A string with the name of the grouping variable.
Defaults to \code{Date}.}

\item{metric}{Character string containing the name of the metric,
e.g. "Collaboration_hours"}
}
\value{
Returns a data frame with \code{Date} (if grouping variable is not set),
the metric, and the corresponding z-score.
}
\description{
This function takes in a selected metric and uses
z-score (number of standard deviations) to identify outliers
across time. There are applications in this for identifying
weeks with abnormally low collaboration activity, e.g. holidays.
Time as a grouping variable can be overridden with the \code{group_var}
argument.
}
\examples{
identify_outlier(sq_data, metric = "Collaboration_hours")

}
\seealso{
Other Data Validation: 
\code{\link{check_query}()},
\code{\link{extract_hr}()},
\code{\link{flag_ch_ratio}()},
\code{\link{flag_em_ratio}()},
\code{\link{flag_extreme}()},
\code{\link{flag_outlooktime}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count_all}()},
\code{\link{hrvar_count}()},
\code{\link{hrvar_trend}()},
\code{\link{identify_churn}()},
\code{\link{identify_holidayweeks}()},
\code{\link{identify_inactiveweeks}()},
\code{\link{identify_nkw}()},
\code{\link{identify_privacythreshold}()},
\code{\link{identify_query}()},
\code{\link{identify_shifts_wp}()},
\code{\link{identify_shifts}()},
\code{\link{identify_tenure}()},
\code{\link{remove_outliers}()},
\code{\link{standardise_pq}()},
\code{\link{subject_validate_report}()},
\code{\link{subject_validate}()},
\code{\link{track_HR_change}()},
\code{\link{validation_report}()}
}
\concept{Data Validation}
