% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlz_prdday.R
\name{anlz_prdday}
\alias{anlz_prdday}
\title{Get predicted data from fitted GAMs across period of observation, every day}
\usage{
anlz_prdday(mod)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}
}
\value{
a \code{data.frame} with predictions
}
\description{
Get predicted data from fitted GAMs across period of observation, every day
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)

mod <- anlz_gam(tomod, trans = 'log10')
anlz_prdday(mod)
}
\concept{analyze}
