% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlz_backtrans.R
\name{anlz_backtrans}
\alias{anlz_backtrans}
\title{Back-transform response variable}
\usage{
anlz_backtrans(dat)
}
\arguments{
\item{dat}{input data with \code{trans} argument}
}
\value{
\code{dat} with the \code{value} column back-transformed using info from the \code{trans} column
}
\description{
Back-transform response variable after fitting GAM
}
\details{
\code{dat} can be output from \code{\link{anlz_trans}} or \code{\link{anlz_prd}}
}
\examples{
library(dplyr)

tomod <- rawdat \%>\% 
  filter(station \%in\% 34) \%>\% 
  filter(param \%in\% 'chl')
dat <- anlz_trans(tomod, trans = 'log10')
backtrans <- anlz_backtrans(dat)
head(backtrans)

mod <- anlz_gam(tomod, trans = 'log10')
dat <- anlz_prd(mod)
backtrans <- anlz_backtrans(dat)
head(backtrans)
}
\concept{analyze}
