% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertPlotCoordPix.R
\name{convertPlotCoordPix}
\alias{convertPlotCoordPix}
\title{Convert points of plot to coordinates in pixels}
\usage{
convertPlotCoordPix(
  x,
  y,
  useMar = c(6.2, 4, 4, 2),
  plotDim = c(1400, 800),
  plotRes = 100,
  fromTop = TRUE,
  callFrom = NULL,
  silent = FALSE
)
}
\arguments{
\item{x}{(numeric) initial plotting coordinates on x-axis, names of vector - if available- will be used as IDs}

\item{y}{(numeric) initial plotting coordinates on y-axis}

\item{useMar}{(numeric,length=4) margins defined with plot, see also \code{\link[graphics]{par}}}

\item{plotDim}{(integer, length=2) dimension of the plotting device in pixels, see also \code{\link[graphics]{par}}}

\item{plotRes}{(integer) resoltion of plotting device, see also \code{\link[graphics]{par}}}

\item{fromTop}{(logical) toggle if poordinates should start from top}

\item{callFrom}{(character) allow easier tracking of message(s) produced}

\item{silent}{(logical) suppress messages}
}
\value{
matrix with x- and y-coordinates in pixels
}
\description{
This function allows conversion the plotting positions ('x' and 'y' coordiantes) of points in a given plot into coordiantes in pixels (of the entire plotting region).
Some functionalities do need such pixel-coordiantes, like \code{\link{mouseOverHtmlFile}} for annotating given points of a plot for mouse-over interactive html.
}
\examples{
df1 <- data.frame(id=letters[1:10],x=1:10,y=rep(5,10),mou=paste("point",letters[1:10]),
  link=file.path(tempdir(),paste(LETTERS[1:10],".html",sep="")),stringsAsFactors=FALSE)  
## here we'll use R's tempdir, later you may want to choose other locations
pngFile <- file.path(tempdir(),"test01.png")
png(pngFile,width=800, height=600,res=72)
## here we'll just plot a set of horiontal points at default parameters ...
plot(df1[,2:3],las=1,main="test01")
dev.off()
## Note: Special characters should be converted for proper display in html during mouse-over
library(wrMisc)
df1$mou <- htmlSpecCharConv(df1$mou)
## Let's add the x- and y-coordiates of the points in pixels to the data.frame
df1 <- cbind(df1,convertPlotCoordPix(x=df1[,2],y=df1[,3],plotD=c(800,600),plotRes=72))
head(df1)
## using mouseOverHtmlFile() one could now make an html document with interactive 
## display of names and clockable links to the coordinates we determined here ...
}
\seealso{
\code{\link{mouseOverHtmlFile}}
}
