% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exclExtrValues.R
\name{exclExtrValues}
\alias{exclExtrValues}
\title{Exclude extreme values (based on distance to mean)}
\usage{
exclExtrValues(dat, result = "val", CVlim = NULL, maxExcl = 1,
  showNA = FALSE, goodValues = TRUE, silent = FALSE,
  callFrom = NULL)
}
\arguments{
\item{dat}{numeric vector, main input}

\item{result}{(character) may be 'val' for returning data without extreme values or 'pos' for returning position/index of extreme values}

\item{CVlim}{(NULL or numeric) allows to retain extreme values only if a certain CV (for all 'dat') is exceeded (to avoid calling extreme values form homogenous data-sets)}

\item{maxExcl}{(integer) max number of elments to explude}

\item{showNA}{(logical) will display extrelme values as NA}

\item{goodValues}{(logical) allows to display rather the good values instead of the extreme values}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
numeric vector wo extremle values or index-position of extreme values
}
\description{
This function aims to identify extreme values (values most distant to mean, thus potential outlyers), mark them as NA or directely exclude them (depending on '\code{showNAs}').
Note that every set of non-identical values will have at least one most extreme value. Extreme values are part of many distributions, they are not necessarily true outliers.
}
\examples{
x <- c(rnorm(30),-6,20)
exclExtrValues(x)
}
\seealso{
\code{\link{firstOfRepLines}},  \code{\link{get1stOfRepeatedByCol}} for treatment of matrix
}
