% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeMatrices.R
\name{mergeMatrixList}
\alias{mergeMatrixList}
\title{Merge Multiple Matrices from List}
\usage{
mergeMatrixList(
  matLst,
  mode = "intersect",
  useColumn = 1,
  extrRowNames = FALSE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{matLst}{(list containing matrices or data.frames) main input (multiple matrix or data.frame objects)}

\item{mode}{(character) allows choosing restricting to all common elements (\code{mode='intersect'}) or union  (\code{mode='union'})}

\item{useColumn}{(integer, character or list) the column(s) to consider, may be \code{'all'} to use all, integer to select specific indexes or list of indexes or colnames for cutom-selection per matrix}

\item{extrRowNames}{(logical) decide whether columns with all values different (ie no replicates or max divergency) should be excluded}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a matrix containing all selected columns of the input matrices to fuse
}
\description{
This function allows merging of multiple matrix-like objects from an initial list.
The matix-rownames will be used to align common elements, either be returning all common elements \code{mode='intersect'} or containg all elements \code{mode='union'} (the result may contains additional \code{NA}s).
}
\details{
Custom column-names can be given by entering matrices like named arguments (see examples below).
The choice of columns tu use may be adopted to each matrix entered, in this case the argument \code{useColumn} may be a list with matrix-names to use or a list of indexes (see examples below).

Note, that matrices may contain repeated rownames (see examples, \code{mat3}). In this case only the first of repeated rownames will be considered (and lines of repeated names ignored).
}
\examples{
mat1 <- matrix(11:18, ncol=2, dimnames=list(letters[3:6],LETTERS[1:2]))
mat2 <- matrix(21:28, ncol=2, dimnames=list(letters[2:5],LETTERS[3:4]))
mat3 <- matrix(31:38, ncol=2, dimnames=list(letters[c(1,3:4,3)],LETTERS[4:5]))

mergeMatrixList(list(mat1, mat2))

mergeMatrixList(list(m1=mat1, m2=mat2, mat3), mode="union", useCol=2)
}
\seealso{
\code{\link[base]{merge}},  \code{\link{mergeMatrices}} for separate entries
}
