% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutToNgrp.R
\name{cutToNgrp}
\alias{cutToNgrp}
\title{Cut numeric vector to n groups (ie convert to factor)}
\usage{
cutToNgrp(x, lev, NAuse = FALSE, callFrom = NULL)
}
\arguments{
\item{x}{numeric vector}

\item{lev}{(character or numeric), the length of this argument tells the number of groups to be used for cutting}

\item{NAuse}{(logical) include NAs as separate group}

\item{callFrom}{(character) for better tracking of use of functions}
}
\value{
list with \code{$grouped} telling which element of '\code{x}' goes in which group and \code{$legTxt} with gourp-borders for convenient use with legends
}
\description{
\code{cutToNgrp} is a more elaborate version of \code{\link[base]{cut}} for cutting a the content of a 
numeric vector '\code{x}' into a given number of groups, taken from the length of '\code{lev}'.
Besides, this function provides the group borders/limits for convention use with legends.
}
\examples{
set.seed(2019); dat <- runif(30) +(1:30)/2
cutToNgrp(dat,1:5)
plot(dat,col=(1:5)[as.numeric(cutToNgrp(dat,1:5)$grouped)])
}
\seealso{
\code{\link[base]{cut}}
}
