% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filt3dimArr.R
\name{.filterSw}
\alias{.filterSw}
\title{Filter 3-dim array of numeric data (main)}
\usage{
.filterSw(x, fiTy, checkVa, indexRet = TRUE)
}
\arguments{
\item{x}{array (3-dim) of numeric data}

\item{fiTy}{(character) which type of testing to perform ('eq','inf','infeq','sup','supeq', '>', '<', '>=', '<=', '==')}

\item{checkVa}{(logical) s}

\item{indexRet}{(logical) if \code{TRUE} (default) rather return index numbers than filtered values}
}
\value{
This function returns either index (position within 'x') or concrete (filtered) result
}
\description{
Filtering of matrix or array \code{x} (may be 3-dim array) according to \code{fiTy} and \code{checkVa}
}
\examples{
arr1 <- array(11:34, dim=c(4,3,2), dimnames=list(c(LETTERS[1:4]),
  paste("col",1:3,sep=""),c("ch1","ch2")))
filt3dimArr(arr1,displCrit=c("col1","col2"),filtCrit="col2",filtVal=7)
.filterSw(arr1, fiTy="inf", checkVa=7)
}
\seealso{
\code{\link{filt3dimArr}}; \code{\link{filterList}}; \code{\link{filterLiColDeList}};
}
