% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchLinesAtGivenSlope.R
\name{.keepCenter1d}
\alias{.keepCenter1d}
\title{Refine/filter 'dat1' (1dim dataset, eg cluster) with aim of keeping center of data}
\usage{
.keepCenter1d(
  dat1,
  core = NULL,
  keepOnly = TRUE,
  displPlot = FALSE,
  silent = TRUE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat1}{simple numeric vector}

\item{core}{numeric vactor (betw 0 and 1) for fraction of data to keep; if null trimmedMean/max hist occurance will be used, limited within 30-70 perent; may also be 'high' or 'low' for forcing low (20-60percent) or high (75-99) percent of data to retain}

\item{keepOnly}{(logical)}

\item{displPlot}{(logical) show plot of hist & boundaries}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns the index of values retained or if 'keepOnly' return list with 'keep' index and 'drop' index
}
\description{
This function allows to refine/filter 'dat1' (1dim dataset, eg cluster) with aim of keeping center of data.
It is done based on most freq class of histogramm keep/filter data if 'core' (% of volume) are within 'core' (%) range
}
\examples{
set.seed(2016); dat1 <- matrix(c(runif(200)+rep(1:10,20)),ncol=10)
}
\seealso{
\code{\link{searchLinesAtGivenSlope}}
}
