% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeThis.R
\name{.normConstSlope}
\alias{.normConstSlope}
\title{Normalize columns of 2dim matrix to common linear regression fit}
\usage{
.normConstSlope(
  mat,
  useQuant = c(0.2, 0.8),
  refLines = NULL,
  diagPlot = TRUE,
  plotLog = "",
  datName = NULL,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{mat}{matrix or data.frame of data to get normalized}

\item{useQuant}{(numeric) quantiles to use}

\item{refLines}{(NULL or numeric) allows to consider only specific lines of 'dat' when determining normalization factors (all data will be normalized)}

\item{diagPlot}{(logical) draw diagnistic plot}

\item{plotLog}{(character) indicate which axis shousl be diplayed on log-scale, may be 'x', 'xy' or 'y'}

\item{datName}{(character) use as title in diag plot}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function returns a numeric vector
}
\description{
This function aims to normalize columns of 2dim matrix to common linear regression fit within range of 'useQuant'
}
\examples{
aa <- matrix(1:12, ncol=3)
}
\seealso{
\code{\link{normalizeThis}}
}
