% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linRegrParamAndPVal.R
\name{linRegrParamAndPVal}
\alias{linRegrParamAndPVal}
\title{Fit linear regression, return parameters and p-values}
\usage{
linRegrParamAndPVal(
  dep,
  y = NULL,
  asVect = TRUE,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dep}{(numeric vector, matrix or data.frame) explanatory or dependent variable, if matrix or data.frame the 1st column will be used, if 'y'=\code{NULL} the 2nd column will be used as 'y'}

\item{y}{(numeric vector) independent variable (the value that should get estimated based on 'dep')}

\item{asVect}{(logical) return numeric vector (Intercept, slope, p.intercept, p.slope) or matrix or results}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
numeric vector (Intercept, slope, p.intercept, p.slope), or if \code{asVect}==\code{TRUE} as matrix (p.values in 2nd column)
}
\description{
This function fits a linear regression and returns the parameters, including p-values from Anova.
Here the vector 'y' (scalar response or dependent variable, ie the value that should get estimated) will be estimated according to 'dep' (explanatory or independent variable).
Alternatively, 'dep' may me a \code{matrix} where 1st column will be used as 'dep and the 2nd column as 'y'.
}
\examples{
linRegrParamAndPVal(c(5,5.1,8,8.2),gl(2,2))
}
\seealso{
\code{\link[stats]{lm}}
}
