% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorAccording2.R
\name{colorAccording2}
\alias{colorAccording2}
\title{Transform Numeric Values To Color-Gradient}
\usage{
colorAccording2(
  x,
  gradTy = "rainbow",
  nStartOmit = NULL,
  nEndOmit = NULL,
  revCol = FALSE,
  alpha = 1,
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{x}{(character) color input}

\item{gradTy}{(character) type of gradeint may be 'rainbow', 'heat.colors', 'terrain.colors', 'topo.colors', 'cm.colors', 'hcl.colors', 'grey.colors', 'gray.colorsW' or 'logGray'}

\item{nStartOmit}{(integer) omit n steps from begining of gradient range}

\item{nEndOmit}{(integer or "sep") omit n steps from end of gradient range, if \code{nEndOmit="sep"} 20 percent of initial grades will be removed to obtain 'separate' ie non-closing color-circles/gradients eg with \code{rainbow}}

\item{revCol}{(logical) reverse order}

\item{alpha}{(numeric) optional transparency value (1 for no transparency, 0 for complete opaqueness)}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) additional messages for debugging}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a character vector (of same length as x) with color encoding
}
\description{
This function helps making color-gradients for plotting a numerical variable.
Note : RColorBrewer palettes were not integrated here/yet.
}
\examples{
set.seed(2015); dat1 <- round(runif(15),2)
plot(1:15,dat1,pch=16,cex=2,col=colorAccording2(dat1))
plot(1:15,dat1,pch=16,cex=2,col=colorAccording2(dat1,nStartO=0,nEndO=4,revCol=TRUE))
plot(1:9,pch=3)
points(1:9,1:9,col=transpGraySca(st=0,en=0.8,nSt=9,trans=0.3),cex=42,pch=16)
}
\seealso{
\code{\link[base]{cut}}
}
