% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atblock.R
\name{ateval}
\alias{ateval}
\title{Evaluate an expression with \code{@name} substitution.}
\usage{
ateval(.)
}
\arguments{
\item{.}{character text of expression or block to evaluate}
}
\description{
The expression represented by the text of the \code{.}-argument is evaluated in
the current environment will all "\code{@name}" forms replaced by the value of name.
This allows variables to carry the names of other variables into what would
be a non-standard evaluation situation.  This adaption allows some parametric
or standard-evaluation effects in such circumstances.
}
\details{
Note: this method uses string substitution and is willing to substitute in arbitrary content,
please prefer using \code{\link{let}} where applicable.

Notation idea: Jonathan Carroll \url{https://jcarroll.com.au} \url{https://twitter.com/carroll_jono/status/842142292253196290}
Similar to: \url{https://dev.mysql.com/doc/refman/5.7/en/user-variables.html}.
}
\examples{


c1 <- 1:5
c2 <- 3:7
col1 <- 'c1'
col2 <- 'c2'
new_col_name <- 'res'
ateval(
  '@new_col_name <- @col1 + @col2'
)
print(res)

# larger example
c3 <- 4:8
terms <- paste(c('c1', 'c2', 'c3'), collapse = ' + ')
print(ateval('@terms'))

}
\seealso{
\code{\link{let}}, \code{\link{beval}},  \code{\link{seval}}
}
