% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_fns.R
\name{transform_columns}
\alias{transform_columns}
\title{Evaluate an expression with a data frame acting as the inner environment
and assigning back to the data.frame.  Statements are executed sequentially.}
\usage{
transform_columns(transform_columns_data_frame, ...,
  transform_columns_env = parent.frame())
}
\arguments{
\item{transform_columns_data_frame}{data.frame to work with}

\item{...}{named exprssions to add to data frame}

\item{transform_columns_env}{environment to work in}
}
\value{
data frame with additional or altered columns
}
\description{
References can be forced to the environment with a .e$ prefix
and forced to the data frame with a .d$ prefix (failure to
lookup returns null). Only works on in-memory data.frames.
Part piping with base R series: \url{http://www.win-vector.com/blog/tag/piping-with-base-r/}.
}
\examples{

d <- data.frame(x = c(1,2))
transform_columns(d, y = x*x, d = 0, z = x + y, d = 1, q = x + d)

}
\seealso{
\code{\link[base]{transform}}, \code{\link[base]{within}}
}
