% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/let.R
\name{let}
\alias{let}
\title{Execute expr with name substitutions specified in alias.}
\usage{
let(alias, expr, ..., envir = parent.frame(), subsMethod = "langsubs",
  strict = TRUE, eval = TRUE, debugPrint = FALSE)
}
\arguments{
\item{alias}{mapping from free names in expr to target names to use (mapping have both unique names and unique values).}

\item{expr}{block to prepare for execution.}

\item{...}{force later arguments to be bound by name.}

\item{envir}{environment to work in.}

\item{subsMethod}{character substitution method, one of  'langsubs' (preferred), 'subsubs', or 'stringsubs'.}

\item{strict}{logical if TRUE names and values must be valid un-quoted names, and not dot.}

\item{eval}{logical if TRUE execute the re-mapped expression (else return it).}

\item{debugPrint}{logical if TRUE print debugging information when in stringsubs mode.}
}
\value{
result of expr executed in calling environment (or expression if eval==FALSE).
}
\description{
\code{let} implements a mapping from desired names (names used directly in the expr code) to names used in the data.
Mnemonic: "expr code symbols are on the left, external data and function argument names are on the right."
}
\details{
Please see the \code{wrapr} \code{vignette} for some discussion of let and crossing function call boundaries: \code{vignette('wrapr','wrapr')}.
For formal documentation please see \url{https://github.com/WinVector/wrapr/blob/master/extras/wrapr_let.pdf}.
Transformation is performed by substitution, so please be wary of unintended name collisions or aliasing.

Something like \code{let} is only useful to get control of a function that is parameterized
(in the sense it take column names) but non-standard (in that it takes column names from
non-standard evaluation argument name capture, and not as simple variables or parameters).  So  \code{wrapr:let} is not
useful for non-parameterized functions (functions that work only over values such as \code{base::sum}),
and not useful for functions take parameters in straightforward way (such as \code{base::merge}'s "\code{by}" argument).
\code{dplyr::mutate} is an example where
we can use a \code{let} helper.   \code{dplyr::mutate} is
parameterized (in the sense it can work over user supplied columns and expressions), but column names are captured through non-standard evaluation
(and it rapidly becomes unwieldy to use complex formulas with the standard evaluation equivalent \code{dplyr::mutate_}).
\code{alias} can not include the symbol "\code{.}".

The intent from is from the user perspective to have (if
\code{a <- 1; b <- 2}):
\code{let(c(z = 'a'), z+b)} to behave a lot like
\code{eval(substitute(z+b, c(z=quote(a))))}.

\code{let} deliberately checks that it is mapping only to legal \code{R} names;
this is to discourage the use of \code{let} to make names to arbitrary values, as
that is the more properly left to \code{R}'s environment systems.
\code{let} is intended to transform
"tame" variable and column names to "tame" variable and column names.  Substitution
outcomes that are not valid simple \code{R} variable names (produced with out use of
back-ticks) are forbidden.  It is suggested that substitution targets be written
\code{ALL_CAPS} style to make them stand out.

\code{let} was inspired by \code{gtools:strmacro()}.
Please see \url{https://github.com/WinVector/wrapr/blob/master/extras/MacrosInR.md} for a discussion of macro tools in \code{R}.
}
\examples{

d <- data.frame(
  Sepal_Length=c(5.8,5.7),
  Sepal_Width=c(4.0,4.4),
  Species='setosa')

mapping <- qc(
  AREA_COL = Sepal_area,
  LENGTH_COL = Sepal_Length,
  WIDTH_COL = Sepal_Width
)

# let-block notation
let(
  mapping,
  d \%.>\%
    transform(., AREA_COL = LENGTH_COL * WIDTH_COL)
)


# Note: in packages can make assignment such as:
#   AREA_COL <- LENGTH_COL <- WIDTH_COL <- NULL
# prior to code so targets don't look like unbound names.


}
\seealso{
\code{\link[base]{bquote}}, \code{\link[base]{do.call}}
}
