% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bquotefn.R
\name{bquote_call_args}
\alias{bquote_call_args}
\title{Treat ... argument as bquoted-values.}
\usage{
bquote_call_args(call, env = parent.frame())
}
\arguments{
\item{call}{result of match.call()}

\item{env}{environment to perform lookups in.}
}
\value{
name list of values
}
\description{
bquote_call_args is a helper to allow the user to write functions with bquote-enabled argument substitution.
Uses convetion that := is considered a alias for =.
Re-writes call args to evaluate \code{expr} with \code{bquote} \code{.()} substitution.
Including \code{.(-x)} promoting \code{x}'s value from character to a name,
which is called "quote negation" (hence the minus-sign).
}
\examples{

f <- function(q, ...) {
  env = parent.frame()
  # match.call() best called in function context.
  captured_call <- match.call()
  captured_args <- bquote_call_args(captured_call, env)
  captured_args
}

z <- "x"
y <- 5
qv <- 3

# equivalent to f(3, x = 5)
f(.(qv), .(z) := .(y))

# equivalent to f(q = 7)
qname <- 'q'
f(.(qname) := 7)


}
\seealso{
\code{\link{bquote_function}}
}
