% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bquotefn.R
\name{evalb}
\alias{evalb}
\title{Near \code{eval(bquote(expr))} shortcut.}
\usage{
evalb(expr, where = parent.frame())
}
\arguments{
\item{expr}{expression to evaluate.}

\item{where}{environment to work in.}
}
\value{
evaluated substituted expression.
}
\description{
Evaluate \code{expr} with \code{bquote} \code{.()} substitution.
Including \code{.(-x)} promoting \code{x}'s value from character to a name,
which is called "quote negation" (hence the minus-sign).
}
\examples{

if(requireNamespace('graphics', quietly = TRUE)) {
   angle = 1:10
   variable <- as.name("angle")
   fn_name <- 'sin'
   evalb(  plot(x = .(variable), y = .(-fn_name)(.(variable))) )
}

}
