% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cssSpectrum.R
\name{cssSpectrum}
\alias{cssSpectrum}
\title{cssSpectrum}
\usage{
cssSpectrum(listOfFiles = NULL, optLogFilePath = NULL, beginTime = 0,
  centerTime = FALSE, endTime = 0, resolution = 40, fftLength = 0,
  windowShift = 5, window = "BLACKMAN", numCeps = 0, toFile = TRUE,
  explicitExt = NULL, outputDirectory = NULL,
  forceToLog = useWrasspLogger, verbose = TRUE)
}
\arguments{
\item{listOfFiles}{vector of file paths to be processed by function}

\item{optLogFilePath}{path to option log file}

\item{beginTime}{= <time>: set begin of analysis interval to <time> seconds
(default: begin of data)}

\item{centerTime}{= <time>: set single-frame analysis with the analysis
window centred at <time> seconds; overrules beginTime, endTime and
windowShift options}

\item{endTime}{= <time>: set end of analysis interval to <time> seconds
(default: end of data)}

\item{resolution}{= <freq>: set FFT length to the smallest value which
results in a freqequency resolution of <freq> Hz or better (default: 40.0)}

\item{fftLength}{= <num>: set FFT length to <num> points (overrules default
and 'resolution' option)}

\item{windowShift}{= <dur>: set analysis window shift to <dur> ms
(default: 5.0)}

\item{window}{= <type>: set analysis window function to <type> (default:
BLACKMAN)}

\item{numCeps}{= <num>: set number of cepstral coeffcients used to <num>
(default: sampling rate in kHz + 1; minimum: 2)}

\item{toFile}{write results to file (default extension depends on )}

\item{explicitExt}{set if you wish to overwride the default extension}

\item{outputDirectory}{directory in which output files are stored. Defaults to NULL, i.e.
the directory of the input files}

\item{forceToLog}{is set by the global package variable useWrasspLogger. This is set
to FALSE by default and should be set to TRUE is logging is desired.}

\item{verbose}{display infos & show progress bar}
}
\value{
nrOfProcessedFiles or if only one file to process return
AsspDataObj of that file
}
\description{
calculate cepstrally smoothed spectrum using libassp
}
\details{
Short-term spectral analysis of the signal in <listOfFiles>
using the Fast Fourier Transform and cepstral smoothing.
Analysis results will be written to a file with the
base name of the input file and '.css.' as extension.
Default output is in SSFF format with
'css' in lower case as track name.
}
\examples{
# get path to audio file
path2wav <- list.files(system.file("extdata", package = "wrassp"), 
                       pattern = glob2rx("*.wav"), 
                       full.names = TRUE)[1]

# calculate cepstrally smoothed spectrum
res <- cssSpectrum(path2wav, toFile=FALSE)

# plot spectral values at midpoint of signal
plot(res$css[dim(res$css)[1]/2,], 
     type='l', 
     xlab='spectral value index', 
     ylab='spectral value')
     
}
\author{
Raphael Winkelmann

Lasse Bombien
}
\seealso{
\code{\link{dftSpectrum}}, \code{\link{lpsSpectrum}}, \code{\link{cepstrum}}; 
all derived from libassp's spectrum function.
}

