% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{xQTLvisual_locusCompare}
\alias{xQTLvisual_locusCompare}
\title{Dotplot of comparing regional signals between GWAS and xQTL.}
\usage{
xQTLvisual_locusCompare(
  eqtlDF,
  gwasDF,
  highlightSnp = "",
  population = "EUR",
  legend = TRUE,
  legend_position = c("topright", "bottomright", "topleft"),
  snpLD = NULL
)
}
\arguments{
\item{eqtlDF}{A data.frame or data.table with two columns: dbSNP id and p-value.}

\item{gwasDF}{A data.frame or data.table with two columns: dbSNP id and p-value.}

\item{highlightSnp}{Default is the snp that is farthest from the origin of the coordinates.}

\item{population}{One of the 5 popuations from 1000 Genomes: 'AFR', 'AMR', 'EAS', 'EUR', and 'SAS'.#' @param token LDlink provided user token, default = NULL, register for token at https://ldlink.nci.nih.gov/?tab=apiaccess}

\item{legend}{(boolean, optional) Should the legend be shown? Default: TRUE.}

\item{legend_position}{(string, optional) Either 'bottomright','topright', or 'topleft'. Default: 'bottomright'.}

\item{snpLD}{A data.frame object of LD matrix. Default is null.}
}
\value{
A ggplot object.
}
\description{
This function is rebuilt from \code{locuscompare.R} (https://github.com/boxiangliu/locuscomparer/blob/master/R/locuscompare.R).
}
\examples{
\donttest{
library(data.table)
# load data:
eqtlDF <-fread("https://gitee.com/stronghoney/exampleData/raw/master/eqtl/eqtlAsso1.txt")
gwasDF <-fread("https://gitee.com/stronghoney/exampleData/raw/master/gwas/AD/gwasChr6Sub3.txt")
# visualize:
xQTLvisual_locusCompare( eqtlDF, gwasDF, legend_position="topleft")
}
}
