% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anno.R
\name{xQTLanno_calLambda}
\alias{xQTLanno_calLambda}
\title{calculate genomic control inflation factor for a QTL/GWAS summary statistics dataset.}
\usage{
xQTLanno_calLambda(summaryDT)
}
\arguments{
\item{summaryDT}{A data.frame containing one or two columns: p-value (required) and group (optional)}
}
\value{
A data.table object
}
\description{
calculate genomic control inflation factor for a QTL/GWAS summary statistics dataset.
}
\examples{
\donttest{
url1 <- "http://bioinfo.szbl.ac.cn/xQTL_biolinks/xqtl_data/eqtl/MMP7_qtlDF.txt"
qtl <- data.table::fread(url1, sep="\t")

# calculate lambda value with all variants
xQTLanno_calLambda(qtl[,.(pValue)])

# calculate lambda value for each group:
qtl$groups <- sample(c(0,1),size = nrow(qtl), replace = TRUE)
xQTLanno_calLambda(qtl[,.(pValue, groups)])
}
}
