% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{xQTLdownload_eqtlAllAssoPos}
\alias{xQTLdownload_eqtlAllAssoPos}
\title{Download summary statistics data for eQTLs with genome positions.}
\usage{
xQTLdownload_eqtlAllAssoPos(
  chrom = "",
  pos_lower = numeric(0),
  pos_upper = numeric(0),
  p_lower = 0,
  p_upper = 1.1,
  gene = "",
  geneType = "auto",
  tissueLabel = "",
  study = "gtex_v8",
  recordPerChunk = 1000,
  withB37VariantId = FALSE
)
}
\arguments{
\item{chrom}{(character) name of chromesome, including chr1-chr22, chrX.}

\item{pos_lower}{(integer) lower base pair location threshold, expressed as an integer}

\item{pos_upper}{(integer) upper base pair location threshold, expressed as an integer}

\item{p_lower}{(numeric) lower p-value threshold, can be expressed as a float or using mantissa and exponent annotation (0.001 or 1e-3 or 1E-3)}

\item{p_upper}{(numeric) upper p-value threshold, can be expressed as a float or using mantissa and exponent annotation (0.001 or 1e-3 or 1E-3)}

\item{gene}{(character) gene symbol or gencode id (versioned or unversioned are both supported).}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{tissueLabel}{(character) all supported tissues can be listed using "ebi_study_tissues".}

\item{study}{(character) name of studies can be listed using "ebi_study_tissues".}

\item{recordPerChunk}{(integer) number of records fetched per request (default: 1000).}

\item{withB37VariantId}{a logical value indicating whether to return the genome location(GTEx v7) of variants. Default: FALSE.}
}
\value{
A data.table object
}
\description{
Download summary statistics data for eQTLs with genome positions.
}
\examples{
\donttest{
eqtlAssos <- xQTLdownload_eqtlAllAssoPos(chrom = "chr11",
                                        pos_lower=101398614, pos_upper = 101402313,
                                        tissueLabel="Brain - Cerebellar Hemisphere",
                                        p_upper=1e-1)
}
}
