% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_RP_v9_Commented.R
\name{make_rp}
\alias{make_rp}
\title{Make recent population}
\usage{
make_rp(sh_out, Male_founders, Female_founders, ng, litter_size, Selection,
  Training, saveAt, rp_output, Display)
}
\arguments{
\item{sh_out}{(\code{list}) Output of function  \code{\link{sample_hp}} or \code{\link{make_rp}}.}

\item{Male_founders}{(\code{data.frame}) Data frame with {1} row and {3} colomns as following:\cr
  Colomn 1) "number" is the number of male individuals to be selected. \cr
  Colomn 2) "generation" is the generation number from which males will be selected.\cr
  Colomn 3) "select" indicates the type of selection with options:
\itemize{
\item{"rnd"}  {Select individuals randomly}.
\item{"phen"}  {Select individuals based on their phenotypes}.
\item{"tbv"}  {Select individuals based on their true breeding value (tbv)}.
\item{"gebv"}  {Select individuals based on their genomic estimated breeding value (gebv). \bold{Note:} If "gebv" was not selection criteria for the population from which founders are being selected, then "gebv" as selection criteria will be ignored}.
}
  Colomn 4) "value" Indicates to select high: "h" or low: "l" values. Note: This colomn is ignored if indviduals are selected randomly.\cr}

\item{Female_founders}{(\code{data.frame}) Data frame with {1} row and {3} columns containing information to select female founders. Details are similar to argument \code{Male_founders}.}

\item{ng}{Number of generations. Range: \eqn{1 \leq \code{ng} \leq 500}.}

\item{litter_size}{Litter size or the number of progeny per dam. Range: \eqn{1 \leq \code{x} \leq 200}.}

\item{Selection}{(\code{data.frame}) Data frame with {2} rows and {3} columns. First row is for the selection design of males and second row is for the selection design of females. The columns are as following:\cr
  Column 1) "size" is the number of individuals to be selected as sires/dams. \cr
  Column 2) "type" indicates the type of selection with options:
\itemize{
\item{"rnd"}  {Select individuals randomly}.
\item{"phen"}  {Select individuals based on their phenotypes}.
\item{"tbv"}  {Select individuals based on their true breeding value (tbv)}.
\item{"gebv"}  {Select individuals based on their genomic estimated breeding value (gebv)}.
}
  Column 3) "value" Indicates to select "h" or "l" values. Note: This colomn is ignored if indviduals are selected randomly.\cr}

\item{Training}{\emph{Optional} (\code{data.frame}) Data frame with {1} row and {8} columns. The columns are as following:\cr
 Column 1) "size" is the number of individuals to be selected for training. \cr
 Column 2) "sel" \emph{Optional} (\code{character}) Indicates the type of the selection of individuals for training. The possible options are:
\itemize{
\item{"rnd"}  {Select individuals for training randomly}.
\item{"min_rel_mrk"}  {Select individuals for training, where genomic relationship among individuals based on marker information is minimum}.
\item{"max_rel_mrk"}  {Select individuals for training, where genomic relationship among individuals based on marker information is maximum}.
\item{"min_rel_qtl"}  {Select individuals for training, where genomic relationship among individuals based on qtl information is minimum}.
\item{"max_rel_qtl"}  {Select individuals for training, where genomic relationship among individuals based on qtl information is maximum}.
}
Default: "rnd" \cr
  Column 3) "method" \emph{Optional} (\code{character}) Method used for the estimation of marker effects. The possible options are:
\itemize{
\item{"BRR"}  {Gaussian prior}.
\item{"BayesA"}  {scaled-t prior}.
\item{"BL"}  {Double-Exponential prior}.
\item{"BayesB"}  {two component mixture prior with a point of mass at zero and a sclaed-t slab}.
\item{"BayesC"}  {two component mixture prior with a point of mass at zero and a Gaussian slab}.
}
Default: "BRR" \cr
 Column 4) "nIter" \emph{Optional} The number of iterations. Default: \eqn{1500} \cr
  Column 5) "burnIn" \emph{Optional} The number of burn-in. Default: \eqn{500} \cr
  Column 6) "thin" \emph{Optional} The number of thinning. Default: \eqn{5} \cr
  Column 7) "save" \emph{Optional} This may include a path and a pre-fix that will be added to the name of the files that are saved as the program runs. Default:"Out_BGLR" \cr 
  Column 8) "show" \emph{Optional} (\code{Logical}) if TRUE the iteration history is printed. Default: \code{TRUE}. \cr
\bold{Note:} This argument is compulsory if \code{"type"} in argument \code{Selection} is "gebv".  More details about the argument can be found in package \pkg{BGLR}.}

\item{saveAt}{\emph{Optional} (\code{character}). Name to be used to save output files.}

\item{rp_output}{\emph{Optional} (\code{data.frame}). Data frame to specify generations indexs and type of data to be written to output files. User can define which type of data and which generation to be written to output files. The possible options are:\cr
\cr
  "data"      Individuals data except their genotypes. \cr
  "qtl"       QTL genotye of individuals coded as {11,12,21,22}. \cr
  "marker"    Marker genotye of individuals. \cr
  "seq"       Genotype (both marker (SNP) and QTL) of individuals.\cr
  "freq_qtl"  QTL allele frequency. \cr
  "freq_mrk"  Marker allele frequency. \cr
\bold{Note:} Both arguments \code{rp_output} and \code{saveAt} should present in the function in order to write the output files.}

\item{Display}{\emph{Optional} (\code{Logical}) Display summary of the simulated generations if is not \code{FALSE}. Default: \code{TRUE}.}
}
\value{
\code{list} with all data of simulated generations.\cr
\describe{
\item{$output}{(\code{list}) Two-level list  (\code{$output[[x]][[y]]}) containing information about simulated generations. First index (x) indicates generation number. It should be noted that as data for base generation (0) is also stored by the function, to retrive data for a specific generation, index should be equal to generation number plus one. As an example to observe data for generation 2 index should be 3 i.e, \code{$output[[3]]$data}. Second index (y) that ranges from {1} to {6} contain the information as following: 
\itemize{
\item{\code{$output[[x]]$data}}  {Individuals data except their genotypes. Here x is the generation index}
\item{\code{$output[[x]]$qtl}}  {QTL genotye of individuals.}.
\item{\code{$output[[x]]$mrk}}   {Marker genotye of individuals}.
\item{\code{$output[[x]]$sequ}}  {Genotype (both marker (SNP) and QTL) of individuals}.
\item{\code{$output[[x]]$freqQTL}}   {QTL allele frequency}.
\item{\code{$output[[x]]$freqMRK}}   {Marker allele frequency}.
}
}
\item{$summary_data}{Data frame with summary of simulated generations}. 
\item{$linkage_map_qtl}{Linkage map for qtl}.  
\item{$linkage_map_mrk}{Linkage map for marker}.
\item{$linkage_map_qtl_mrk}{Integrated linkage map for both marker and qtl}.
\item{$allele_effcts}{QTL allele effects}.
\item{$trait}{Trait specifications}.
\item{$genome}{Genome specifications}.
}
}
\description{
Creates recent population similar to function \code{\link{sample_hp}} with some modifications.
}
\details{
Function \code{make_rp} is used to create recent population(s) similar to function \code{sample_hp}. The difference between these two functions is that, for function \code{sample_hp}, male and female founders are always from the last generation of historical population. However, in function \code{make_rp}, male and female founders can be selected from any generation of population created by function \code{sample_hp} or in the second usage, founders can be selected from any generation of population created by the function \code{make_rp} itself. So, basically function \code{make_rp} can be used multiple times to sample individuals from the desired generation of population created by function \code{sample_hp} or function \code{make_rp}. See details for function \code{\link{sample_hp}} and the package vignette for more clarification. \cr
}
\examples{
# # # Simulation of a population where founders are from a population created by function sample_hp.

# CREATE HISTORICAL POPULATION

genome<-data.frame(matrix(NA, nrow=2, ncol=6))
names(genome)<-c("chr","len","nmrk","mpos","nqtl","qpos")
genome$chr<-c(1,2)
genome$len<-c(12,8)	
genome$nmrk<-c(140,80)
genome$mpos<-c("rnd","even")	
genome$nqtl<-c(25,25)
genome$qpos<-rep("rnd",2)	
genome

hp<-make_hp(hpsize=100
,ng=10,h2=0.3,phen_var=1
,genome=genome,mutr=5*10**-4,sel_seq_qtl=0.05,sel_seq_mrk=0.05,laf=0.5)

# # MAKE FIRST RECENT POPULATION USING FUNCTION sample_hp 

Male_founders<-data.frame(number=50,select='rnd') 
Female_founders<-data.frame(number=50,select='rnd')   

# Selection scheme in each generation of recent population 
Selection<-data.frame(matrix(NA, nrow=2, ncol=2))
names(Selection)<-c('Number','type')
Selection$Number[1:2]<-c(50,50)	
Selection$type[1:2]<-c('rnd','rnd')	
Selection

RP_1<-sample_hp(hp_out=hp,Male_founders=
Male_founders,Female_founders=Female_founders,
ng=4,Selection=Selection,Training=Training,
litter_size=3,Display=TRUE)

# # MAKE SECOND RP (RP2) USING FUNCTION make_hp 
  # Select founders 
  # Select 30 males based on 'tbv' from generation  2 of RP1. 
  # Select 40 females based on 'phen' from generation 4 of RP1. 

Males<-data.frame(number=30,generation=2,select='tbv',value='h')
Females<-data.frame(number=40,generation=4,select='phen',value='l')

# Selection scheme for RP2

# Selection of 20 sires and 50 dam			
# Selection criteria is "tbv" for sires and "phen" for dams

Selection<-data.frame(matrix(NA, nrow=2, ncol=3))
names(Selection)<-c('Number','type','Value')
Selection$Number[1:2]<-c(20,50)	
Selection$type[1:2]<-c('tbv','phen')	
Selection$Value[1:2]<-c('h','h') 
Selection

# Save "data" and "qtl" for first and last generation of RP1

rp2_output<-data.frame(matrix(NA, nrow=2, ncol=2))
names(rp2_output)<-c("data","qtl")
rp2_output[,1]<-c(1,4) # Save data for generations 1 and 4
rp2_output[,2]<-c(1,4) # Save qtl genotype for generations 1 and 4
rp2_output

RP_2<-make_rp(sh_out=RP_1,Male_founders=Males,
Female_founders=Females,Selection=Selection,
ng=4,litter_size=4,saveAt='RP2',
rp_output=rp2_output)

# Some output display

RP_2$summary_data
RP_2$output[[1]]$data # Data for base Generation
RP_2$output[[2]]$freqQTL # qtl frequencies for 1st Generation
RP_2$output[[4]]$freqMRK # Marker frequencies for 3rd Generation
RP_2$linkage_map_qtl
RP_2$allele_effcts
}
\seealso{
\code{\link{sample_hp}}
}
