\name{typeset}
\alias{typeset}
\alias{typeset.LaTeXdocument}
\alias{typeset.character}
\title{
  Typeset a LaTeX Document
}
\description{
  Typeset a LaTeX document, either from a character value or
  from an external file.
}
\usage{
typeset(tex,
        engine=getOption("xdvir.engine"),
        ...)
\method{typeset}{LaTeXdocument}(tex,
        engine=NULL,
        texFile=NULL,
        ...)
\method{typeset}{character}(tex,
        engine=NULL,
        texFile=NULL,
        sig=FALSE, 
        ...)
}
\arguments{
  \item{tex}{LaTeX code.  See Details.}
  \item{engine}{The TeX engine that should be used to typeset the LaTeX.
    May be the name of a TeX engine (character)
    or a \code{"TeXengine"} object.}
  \item{texFile}{Name of a file to use for LaTeX code.}
  \item{sig}{Add a signature to the DVI output?}
  \item{\dots}{
    Arguments passed to other \code{\link{typeset}} methods.}
}
\details{
  \code{typeset()} expects input to be either a \code{"TeXdocument"},
  as generated by \code{author}, or a
  character value containing LaTeX code.
}
\value{
  A \code{"DVI"} object as produced by \code{\link{readDVI}}.
}
\author{
  Paul Murrell
}
\seealso{
  \code{\link{LaTeXpackage}}.
}
\examples{
\dontrun{
# Requires TeX installation
tex <- author("this is a test")
typeset(tex)
}
}
\keyword{ dplot }

