% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfDecode.R
\name{xegaDfGeneMapFactory}
\alias{xegaDfGeneMapFactory}
\title{Configure the gene map function of a genetic algorithm.}
\usage{
xegaDfGeneMapFactory(method = "Identity")
}
\arguments{
\item{method}{String specifying the GeneMap function.}
}
\value{
Gene map function for genes.
}
\description{
\code{xegaDfGeneMapFactory()} implements the selection
             of one of the GeneMap functions in this
             package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error) if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item "Identity" returns \code{GeneMapIdentity()}. (Default)
             }
}
\examples{
XGene<-xegaDfGeneMapFactory("Identity")
gene1<-xegaDfInitGene(lFxegaDfGene)
XGene(gene1, lFxegaDfGene$penv)
}
\seealso{
Other Configuration: 
\code{\link{lFxegaDfGene}},
\code{\link{xegaDfCrossoverFactory}()},
\code{\link{xegaDfMutationFactory}()},
\code{\link{xegaDfReplicationFactory}()},
\code{\link{xegaDfScaleFactorFactory}()}
}
\concept{Configuration}
