% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaDecode.R
\name{xegaGaGeneMapFactory}
\alias{xegaGaGeneMapFactory}
\title{Configure the gene map function of a genetic algorithm.}
\usage{
xegaGaGeneMapFactory(method = "Bin2Dec")
}
\arguments{
\item{method}{A string specifying the GeneMap function.}
}
\value{
A gene map function for genes.
}
\description{
\code{xegaGaGeneMapFactory} implements the selection
             of one of the GeneMap functions in this
             package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error) if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item "Bin2Dec" returns \code{GeneMap}. (Default).
             \item "Gray2Dec" returns \code{GeneMapGray}.
             \item "Identity" returns \code{GeneMapIdentity}.
             \item "Permutation" returns \code{GeneMapPerm}.
             }
}
\examples{
XGene<-xegaGaGeneMapFactory("Identity")
gene1<-xegaGaInitGene(lFxegaGaGene)
XGene(gene1, lFxegaGaGene$penv)
}
\seealso{
Other Configuration: 
\code{\link{lFxegaGaGene}},
\code{\link{xegaGaCrossoverFactory}()},
\code{\link{xegaGaMutationFactory}()},
\code{\link{xegaGaReplicationFactory}()}
}
\concept{Configuration}
