% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGaCrossover.R
\name{xegaGaCrossGene}
\alias{xegaGaCrossGene}
\title{One point crossover of 2 genes.}
\usage{
xegaGaCrossGene(gg1, gg2, lF)
}
\arguments{
\item{gg1}{A binary gene.}

\item{gg2}{A binary gene.}

\item{lF}{The local configuration of the genetic algorithm.}
}
\value{
A list of one binary gene.
}
\description{
\code{xegaGaCrossGene()} randomly determines a cut point.
             It combines the bits before the cut point of the first gene
             with the bits after the cut point from the second gene (kid 1).
}
\examples{
gene1<-xegaGaInitGene(lFxegaGaGene)
gene2<-xegaGaInitGene(lFxegaGaGene)
xegaGaDecodeGene(gene1, lFxegaGaGene)
xegaGaDecodeGene(gene2, lFxegaGaGene)
gene3<-xegaGaCrossGene(gene1, gene2, lFxegaGaGene)
xegaGaDecodeGene(gene3[[1]], lFxegaGaGene)
}
\seealso{
Other Crossover (Returns 1 Kid): 
\code{\link{xegaGaUCrossGene}()},
\code{\link{xegaGaUPCrossGene}()}
}
\concept{Crossover (Returns 1 Kid)}
