% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acceptance.R
\name{AcceptIVMetropolis}
\alias{AcceptIVMetropolis}
\title{Individually Adaptive Metropolis Acceptance Rule.}
\usage{
AcceptIVMetropolis(OperatorPipeline, gene, lF)
}
\arguments{
\item{OperatorPipeline}{Genetic operator pipeline.}

\item{gene}{Gene.}

\item{lF}{Local configuration.}
}
\value{
The new gene if it has at least equal performance as the old gene 
        else the old gene.
}
\description{
Change the gene by a genetic operator pipeline.
             Always accept new genes with fitness improvement.
             For maximizing fitness
             accept genes with lower fitness with probability
             \code{(runif(1)<exp(-(fitness-newfitness)*beta/Temperature)}
             and reduce temperature with a cooling schedule.
             For each gene, the temperature is corrected upward by a term 
             whose size is proportional to 
             the difference between the fitness of the current best gene 
             in the population and the fitness of the gene.
}
\details{
The temperature is updated at the end of each generation
         in the main loop of the genetic algorithm.
}
\examples{
parm<-function(x){function() {return(x)}}
lFxegaGaGene$Beta<-parm(1)
lFxegaGaGene$TempK<-parm(10)
set.seed(2)
OPpipe1<-function(g, lF){InitGene(lF)}
g1<-lFxegaGaGene$EvalGene(InitGene(lFxegaGaGene), lFxegaGaGene)
lFxegaGaGene$CBestFitness<-parm(g1$fit)
g2<-AcceptMetropolis(OPpipe1, g1, lFxegaGaGene)
}
\references{
Locatelli, M. (2000):
     Convergence of a Simulated Annealing Algorithm for 
     Continuous Global Optimization.
     Journal of Global Optimization, 18:219-233.
     <doi:10.1023/A:1008339019740>

The-Crankshaft Publishing (2023):
A Comparison of Cooling Schedules for Simulated Annealing.
<URL:https://what-when-how.com/artificial-intelligence/a-comparison-of-cooling-schedules-for-simulated-annealing-artificial-intelligence/>
}
\seealso{
Other Acceptance Rule: 
\code{\link{AcceptBest}()},
\code{\link{AcceptMetropolis}()},
\code{\link{AcceptNewGene}()}
}
\concept{Acceptance Rule}
